'use client'
import { useTheme } from 'next-themes'
import React, { useEffect, useState } from 'react'

const CustomImage = ({ className, lightsrc, darksrc, alt }) => {
    const { theme } = useTheme()
    const [mounted, setMounted] = useState(false)

    useEffect(() => {
        setMounted(true)
    }, [])

    // Default to light theme during SSR to prevent hydration mismatch
    const imageSrc = mounted 
        ? ((theme == 'light' || !theme) ? lightsrc : darksrc)
        : lightsrc

    return (
        <img 
            className={className} 
            src={imageSrc} 
            alt={alt}
            suppressHydrationWarning
        />
    )
}

export default CustomImage