// PAGES DATA

export const INDUSTRY_AUTOMOTIVE_DATA = (t) => [
  {
    tabKey: t("indust_automotive_s1_h"),
    heading: t("indust_automotive_s1_h"),
    content: t("indust_automotive_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s2_1.png",
        heading: t("indust_automotive_s2_t1"),
        alt: "Professional market research services tailored for Saudi businesses.",
      },
      {
        imageUrl: "/images/automotive_s2_2.png",
        heading: t("indust_automotive_s2_t6"),
        alt: "Expert business strategy consulting for sustainable growth in Jeddah.",
      },
    ],
  },
  {
    tabKey: t("indust_automotive_s2_h"),
    heading: t("indust_automotive_s2_h"),
    content: t("indust_automotive_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s2_1.png",
        heading: t("indust_automotive_s2_t1"),
        alt: "Professional market research services tailored for Saudi businesses.",
      },
      {
        imageUrl: "/images/automotive_s2_2.png",
        heading: t("indust_automotive_s2_t2"),
        alt: "Comprehensive product testing to ensure market success in Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s2_3.png",
        heading: t("indust_automotive_s2_t3"),
        alt: "Innovative branding solutions to elevate your market presence.",
      },
      {
        imageUrl: "/images/automotive_s2_4.png",
        heading: t("indust_automotive_s2_t4"),
        alt: "In-depth consumer behavior analysis for actionable insights.",
      },
      {
        imageUrl: "/images/automotive_s2_5.png",
        heading: t("indust_automotive_s2_t5"),
        alt: "Custom market research services for Saudi Arabia’s automotive sector.",
      },
      {
        imageUrl: "/images/automotive_s2_6.png",
        heading: t("indust_automotive_s2_t6"),
        alt: "Market analysis and consulting for fast-moving consumer goods.",
      },
      {
        imageUrl: "/images/automotive_s2_7.png",
        heading: t("indust_automotive_s2_t7"),
        alt: "Strategic market research solutions for Saudi real estate projects.",
      },
    ],
  },
  {
    tabKey: t("indust_automotive_s3_h"),
    heading: t("indust_automotive_s3_h"),
    content: t("indust_automotive_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_1.png",
        heading: t("indust_automotive_s3_t1"),
        alt: "Detailed shopper research to boost retail performance.",
      },
      {
        imageUrl: "/images/automotive_s3_2.png",
        heading: t("indust_automotive_s3_t2"),
        alt: "Our expert team delivering innovative market research solutions.",
      },
      {
        imageUrl: "/images/automotive_s3_3.png",
        heading: t("indust_automotive_s3_t3"),
        alt: "Focal Point's modern office in Jeddah, Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s3_4.png",
        heading: t("indust_automotive_s3_t4"),
        alt: "Dedicated client collaboration to drive business success.",
      },
    ],
  },
  {
    tabKey: t("indust_automotive_s4_h"),
    heading: t("indust_automotive_s4_h"),
    content: t("indust_automotive_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s4_1.png",
        heading: t("indust_automotive_s4_t1"),
        alt: "Advanced data analysis tools for accurate market insights.",
      },
      {
        imageUrl: "/images/automotive_s4_2.png",
        heading: t("indust_automotive_s4_t2"),
        alt: "Interactive virtual shopper tools for promotional strategies.",
      },
      {
        imageUrl: "/images/automotive_s4_3.png",
        heading: t("indust_automotive_s4_t3"),
        alt: "Cutting-edge eye-tracking technology for shopper research.",
      },
    ],
  },
  {
    tabKey: t("indust_automotive_s5_h"),
    heading: t("indust_automotive_s5_h"),
    content: t("indust_automotive_s5_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s5_1.png",
        heading: t("indust_automotive_s5_t1"),
        alt: "Showcasing successful projects and business growth strategies.",
      },
      {
        imageUrl: "/images/automotive_s5_2.png",
        heading: t("indust_automotive_s5_t2"),
        alt: "Proven strategies driving measurable market growth in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_automotive_s6_h"),
    heading: t("indust_automotive_s6_h"),
    content: t("indust_automotive_s6_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s6_1.png",
        heading: t("indust_automotive_s6_t1"),
        alt: "Periodic maintenance price comparison for automotive services.",
      },
      {
        imageUrl: "/images/automotive_s6_2.png",
        heading: t("indust_automotive_s6_t2"),
        alt: "Spare parts price tracking research for automotive sector.",
      },
      {
        imageUrl: "/images/automotive_s4_3.png",
        heading: t("indust_automotive_s6_t3"),
        alt: "Repair & body works service evaluation in Saudi Arabia.",
      },
    ],
  },
];

export const GOVERNMENT_AND_PUBLIC_SECTOR_DATA = (t) => [
  {
    tabKey: t("indust_govsec_h"),
    heading: t("indust_govsec_h"),
    content: t("indust_govsec_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/gov_s1_1.png",
        heading: t("indust_govsec_s1_t1"),
        alt: "Government sector market research and consulting services in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_govsec_s2_h"),
    heading: t("indust_govsec_s2_h"),
    content: t("indust_govsec_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/gov_s2_1.png",
        heading: t("indust_govsec_s2_t1"),
        alt: "Public sector analysis and strategy consulting for government initiatives in KSA.",
      },
    ],
  },
  {
    tabKey: t("indust_govsec_s3_h"),
    heading: t("indust_govsec_s3_h"),
    content: t("indust_govsec_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/gov_s3_1.png",
        heading: t("indust_govsec_s3_t1"),
        alt: "In-depth public policy analysis and implementation strategies in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_govsec_s4_h"),
    heading: t("indust_govsec_s4_h"),
    content: t("indust_govsec_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_1.png",
        heading: t("indust_govsec_s4_t1"),
        alt: "Strategic planning and development for government projects and public services.",
      },
    ],
  },
];

export const FMCG_DATA = (t) => [
  {
    tabKey: t("indust_fmcg_s1_h"),
    heading: t("indust_fmcg_s1_h"),
    content: t("indust_fmcg_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s2_1.png",
        heading: t("indust_fmcg_s1_t1"),
        alt: "FMCG market research insights for consumer behavior analysis in Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s2_2.png",
        heading: t("indust_fmcg_s1_t2"),
        alt: "Comprehensive FMCG sector analysis for market growth in KSA.",
      },
    ],
  },
  {
    tabKey: t("indust_fmcg_s2_h"),
    heading: t("indust_fmcg_s2_h"),
    content: t("indust_fmcg_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_fmcg_s2_t1"),
        alt: "FMCG product innovation research in Saudi Arabia.",
      },
      {
        imageUrl: "/images/fmg_s2_2.png",
        heading: t("indust_fmcg_s2_t2"),
        alt: "Consumer feedback analysis on FMCG products in the Saudi market.",
      },
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_fmcg_s2_t3"),
        alt: "In-depth product testing for FMCG market success in Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s2_3.png",
        heading: t("indust_fmcg_s2_t4"),
        alt: "FMCG marketing campaign effectiveness research in Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s4_2.png",
        heading: t("indust_fmcg_s2_t5"),
        alt: "FMCG pricing strategy research in Saudi Arabia's competitive market.",
      },
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_fmcg_s2_t6"),
        alt: "Market penetration strategies for FMCG products in KSA.",
      },
    ],
  },
  {
    tabKey: t("indust_fmcg_s3_h"),
    heading: t("indust_fmcg_s3_h"),
    content: t("indust_fmcg_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_4.png",
        heading: t("indust_fmcg_s3_t1"),
        alt: "FMCG customer loyalty and satisfaction research in Saudi Arabia.",
      },
      {
        imageUrl: "/images/fmg_s3_2.png",
        heading: t("indust_fmcg_s3_t2"),
        alt: "Consumer behavior tracking for FMCG products in Saudi Arabia.",
      },
      {
        imageUrl: "/images/fmg_s3_3.png",
        heading: t("indust_fmcg_s3_t3"),
        alt: "FMCG brand awareness research in the Saudi Arabian market.",
      },
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_fmcg_s3_t4"),
        alt: "Impact of FMCG advertising on consumer preferences in Saudi Arabia.",
      },
      {
        imageUrl: "/images/fmg_s3_5.png",
        heading: t("indust_fmcg_s3_t5"),
        alt: "FMCG product positioning and marketing research in KSA.",
      },
    ],
  },
  {
    tabKey: t("indust_fmcg_s4_h"),
    heading: t("indust_fmcg_s4_h"),
    content: t("indust_fmcg_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_1.png",
        heading: t("indust_fmcg_s4_t1"),
        alt: "FMCG product development and prototype testing for market entry in Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s3_3.png",
        heading: t("indust_fmcg_s4_t2"),
        alt: "Consumer feedback and preferences for FMCG product prototypes in KSA.",
      },
      {
        imageUrl: "/images/fmg_s4_3.png",
        heading: t("indust_fmcg_s4_t3"),
        alt: "FMCG product specifications and features research for Saudi consumers.",
      },
    ],
  },
];

export const REAL_ESTATE_DATA = (t) => [
  {
    tabKey: t("indust_realestate_s1_h"),
    heading: t("indust_realestate_s1_h"),
    content: t("indust_realestate_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_realestate_s1_t1"),
        alt: "Real estate market research insights for Saudi Arabia’s property market.",
      },
      {
        imageUrl: "/images/automotive_s1_1.png",
        heading: t("indust_realestate_s1_t2"),
        alt: "Property development trends and analysis in Saudi real estate sector.",
      },
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_realestate_s1_t3"),
        alt: "Strategic real estate market analysis for commercial properties in KSA.",
      },
      {
        imageUrl: "/images/automotive_s2_6.png",
        heading: t("indust_realestate_s1_t4"),
        alt: "Real estate investment opportunities and market assessments in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_realestate_s2_h"),
    heading: t("indust_realestate_s2_h"),
    content: t("indust_realestate_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_realestate_s2_t1"),
        alt: "Market research for residential property sales in Saudi Arabia.",
      },
      {
        imageUrl: "/images/realestate_s2_2.png",
        heading: t("indust_realestate_s2_t2"),
        alt: "Insights on commercial property trends in Saudi Arabia’s real estate sector.",
      },
      {
        imageUrl: "/images/fmg_s3_3.png",
        heading: t("indust_realestate_s2_t4"),
        alt: "Real estate buyer behavior analysis for residential and commercial sectors in KSA.",
      },
      {
        imageUrl: "/images/fmg_s3_5.png",
        heading: t("indust_realestate_s2_t5"),
        alt: "Real estate market performance evaluation for Saudi property investments.",
      },
    ],
  },
  {
    tabKey: t("indust_realestate_s3_h"),
    heading: t("indust_realestate_s3_h"),
    content: t("indust_realestate_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s2_6.png",
        heading: t("indust_realestate_s3_t1"),
        alt: "Real estate investment trends and analysis for Saudi Arabia’s growing property market.",
      },
    ],
  },
];

export const FOOD_AND_BEVERAGE_DATA = (t) => [
  {
    tabKey: t("indust_food_s1_h"),
    heading: t("indust_food_s1_h"),
    content: t("indust_food_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s1_1.png",
        heading: t("indust_food_s1_t1"),
        alt: "Food and beverage market trends in Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s2_1.png",
        heading: t("indust_food_s1_t2"),
        alt: "Consumer preferences in the food and beverage sector of Saudi Arabia.",
      },
      {
        imageUrl: "/images/automotive_s2_6.png",
        heading: t("indust_food_s1_t3"),
        alt: "Food and beverage industry innovation in the Saudi Arabian market.",
      },
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_food_s1_t4"),
        alt: "Growth of the food and beverage retail sector in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_food_s2_h"),
    heading: t("indust_food_s2_h"),
    content: t("indust_food_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_4.png",
        heading: t("indust_food_s2_t1"),
        alt: "Market analysis for food and beverage distribution in Saudi Arabia.",
      },
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_food_s2_t2"),
        alt: "Food service industry dynamics in the Saudi Arabian market.",
      },
      {
        imageUrl: "/images/fmg_s3_2.png",
        heading: t("indust_food_s2_t3"),
        alt: "Food and beverage packaging trends in Saudi Arabia.",
      },
      {
        imageUrl: "/images/fmg_s3_5.png",
        heading: t("indust_food_s2_t4"),
        alt: "Consumer demand and food safety standards in the Saudi food industry.",
      },
      {
        imageUrl: "/images/fmg_s3_3.png",
        heading: t("indust_food_s2_t5"),
        alt: "Trends in the beverage sector within Saudi Arabia’s food industry.",
      },
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_food_s2_t6"),
        alt: "Food industry innovations and technological advancements in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_food_s3_h"),
    heading: t("indust_food_s3_h"),
    content: t("indust_food_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_3.png",
        heading: t("indust_food_s3_t1"),
        alt: "Consumer-driven trends in Saudi food and beverage consumption.",
      },
      {
        imageUrl: "/images/automotive_s3_1.png",
        heading: t("indust_food_s3_t2"),
        alt: "Impact of sustainability in the Saudi food and beverage supply chain.",
      },
      {
        imageUrl: "/images/automotive_s3_2.png",
        heading: t("indust_food_s3_t3"),
        alt: "Innovation in food production processes in the Saudi Arabian market.",
      },
    ],
  },
];

export const INDUSTRIAL_MANUFACTURING_DATA = (t) => [
  {
    tabKey: t("indust_industrial_s1_h"),
    heading: t("indust_industrial_s1_h"),
    content: t("indust_industrial_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/industrial_s1_2.png",
        heading: t("indust_industrial_s1_t1"),
        alt: "Industrial manufacturing process automation in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_industrial_s2_h"),
    heading: t("indust_industrial_s2_h"),
    content: t("indust_industrial_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_industrial_s2_t1"),
        alt: "Key trends in the industrial manufacturing sector of Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_industrial_s3_h"),
    heading: t("indust_industrial_s3_h"),
    content: t("indust_industrial_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/automotive_s3_4.png",
        heading: t("indust_industrial_s3_t1"),
        alt: "The role of automation in Saudi Arabia's industrial manufacturing industry.",
      },
    ],
  },
  {
    tabKey: t("indust_industrial_s4_h"),
    heading: t("indust_industrial_s4_h"),
    content: t("indust_industrial_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/industrial_s4_1.png",
        heading: t("indust_industrial_s4_t1"),
        alt: "Industrial machinery innovations in Saudi Arabia’s manufacturing industry.",
      },
    ],
  },
  {
    tabKey: t("indust_industrial_s5_h"),
    heading: t("indust_industrial_s5_h"),
    content: t("indust_industrial_s5_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/consultant_s4_2.png",
        heading: t("indust_industrial_s5_t1"),
        alt: "Consultancy services for industrial manufacturing in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_industrial_s6_h"),
    heading: t("indust_industrial_s6_h"),
    content: t("indust_industrial_s6_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s2_2.png",
        heading: t("indust_industrial_6_t1"),
        alt: "Supply chain optimization for industrial manufacturing in Saudi Arabia.",
      },
    ],
  },
];

export const CONSULTANT_AND_AGENCIES = (t) => [
  {
    tabKey: t("indust_consultant_s1_h"),
    heading: t("indust_consultant_s1_h"),
    content: t("indust_consultant_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_consultant_s1_t1"),
        alt: "Consulting services for industrial manufacturing in Saudi Arabia.",
      },
    ],
  },
  {
    tabKey: t("indust_consultant_s2_h"),
    heading: t("indust_consultant_s2_h"),
    content: t("indust_consultant_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/consultant_s2_1.png",
        heading: t("indust_consultant_s2_t1"),
        alt: "Expert consultancy services for industrial manufacturing projects.",
      },
    ],
  },
  {
    tabKey: t("indust_consultant_s3_h"),
    heading: t("indust_consultant_s3_h"),
    content: t("indust_consultant_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/tech_s4_1.png",
        heading: t("indust_consultant_s3_t1"),
        alt: "Advanced technology solutions for manufacturing consulting.",
      },
    ],
  },
  {
    tabKey: t("indust_consultant_s4_h"),
    heading: t("indust_consultant_s4_h"),
    content: t("indust_consultant_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/consultant_s4_1.png",
        heading: t("indust_consultant_s4_t1"),
        alt: "Industry-specific consultancy for manufacturing and industrial sectors.",
      },
      {
        imageUrl: "/images/consultant_s4_2.png",
        heading: t("indust_consultant_s4_t2"),
        alt: "Strategic consultancy services for operational efficiency in manufacturing.",
      },
    ],
  },
  {
    tabKey: t("indust_consultant_s5_h"),
    heading: t("indust_consultant_s5_h"),
    content: t("indust_consultant_s5_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/consultant_s5_1.png",
        heading: t("indust_consultant_s5_t1"),
        alt: "Consultancy in supply chain optimization and industrial performance.",
      },
    ],
  },
];

export const TECHNOLOGY_AND_TELECOM_DATA = (t) => [
  {
    tabKey: t("indust_tech_s1_h"),
    heading: t("indust_tech_s1_h"),
    content: t("indust_tech_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_tech_s1_t1"),
        alt: "Real estate technology solutions for enhanced property management.",
      },
      {
        imageUrl: "/images/automotive_s2_1.png",
        heading: t("indust_tech_s1_t2"),
        alt: "Automotive technology applications in telecom and communication.",
      },
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_tech_s1_t3"),
        alt: "Real estate automation technology for optimized infrastructure.",
      },
      {
        imageUrl: "/images/automotive_s2_6.png",
        heading: t("indust_tech_s1_t4"),
        alt: "Advanced automotive technology applications in the telecom industry.",
      },
    ],
  },
  {
    tabKey: t("indust_tech_s2_h"),
    heading: t("indust_tech_s2_h"),
    content: t("indust_tech_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s2_2.png",
        heading: t("indust_consultant_s2_t1"),
        alt: "FMG technology solutions for industrial sectors.",
      },
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_tech_s2_t2"),
        alt: "Advanced technology solutions in telecom infrastructure.",
      },
      {
        imageUrl: "/images/fmg_s2_2.png",
        heading: t("indust_tech_s2_t3"),
        alt: "Telecom industry technology integration in infrastructure.",
      },
      {
        imageUrl: "/images/automotive_s4_2.png",
        heading: t("indust_tech_s2_t4"),
        alt: "Automotive technology advancements for telecom services.",
      },
      {
        imageUrl: "/images/automotive_s2_3.png",
        heading: t("indust_tech_s2_t5"),
        alt: "Telecommunications technology enhancing automotive industries.",
      },
      {
        imageUrl: "/images/tech_s2_1.png",
        heading: t("indust_tech_s2_t6"),
        alt: "Cutting-edge technology solutions for the telecom sector.",
      },
    ],
  },
  {
    tabKey: t("indust_tech_s3_h"),
    heading: t("indust_tech_s3_h"),
    content: t("indust_tech_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_tech_s3_h"),
        alt: "Telecom technology used to boost communication networks.",
      },
      {
        imageUrl: "/images/realestate_s2_2.png",
        heading: t("indust_tech_s3_t2"),
        alt: "Real estate market analysis using telecom technology.",
      },
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_tech_s3_t3"),
        alt: "Technology-driven solutions in the telecom industry.",
      },
      {
        imageUrl: "/images/fmg_s3_3.png",
        heading: t("indust_tech_s3_t4"),
        alt: "Telecom applications in the manufacturing sector.",
      },
      {
        imageUrl: "/images/fmg_s3_2.png",
        heading: t("indust_tech_s3_t5"),
        alt: "Telecom integration for better manufacturing operations.",
      },
      {
        imageUrl: "/images/automotive_s3_4.png",
        heading: t("indust_tech_s3_t6"),
        alt: "Telecommunications technology transforming automotive industry.",
      },
      {
        imageUrl: "/images/fmg_s3_5.png",
        heading: t("indust_tech_s3_t7"),
        alt: "Next-gen technology solutions for telecom and industry sectors.",
      },
    ],
  },
  {
    tabKey: t("indust_tech_s4_h"),
    heading: t("indust_tech_s4_h"),
    content: t("indust_tech_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/tech_s4_1.png",
        heading: t("indust_tech_s4_t2"),
        alt: "Innovative telecom solutions for modern technology challenges.",
      },
      {
        imageUrl: "/images/automotive_s3_2.png",
        heading: t("indust_tech_s4_t3"),
        alt: "Automotive telecom technology solutions for connected vehicles.",
      },
      {
        imageUrl: "/images/automotive_s3_1.png",
        heading: t("indust_tech_s4_t4"),
        alt: "Telecommunications technologies powering the automotive sector.",
      },
      {
        imageUrl: "/images/automotive_s3_3.png",
        heading: t("indust_tech_s4_t5"),
        alt: "Automotive technology innovations impacting the telecom industry.",
      },
    ],
  },
];

export const OTHER_DATA = (t) => [
  {
    tabKey: t("indust_tech_s1_h"),
    heading: t("indust_tech_s1_h"),
    content: t("indust_tech_s1_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_tech_s1_t1"),
        alt: "Real estate technology solutions for enhanced property management.",
      },
      {
        imageUrl: "/images/automotive_s2_1.png",
        heading: t("indust_tech_s1_t2"),
        alt: "Automotive technology applications in telecom and communication.",
      },
      {
        imageUrl: "/images/realestate_s1_1.png",
        heading: t("indust_tech_s1_t3"),
        alt: "Real estate automation technology for optimized infrastructure.",
      },
      {
        imageUrl: "/images/automotive_s2_6.png",
        heading: t("indust_tech_s1_t4"),
        alt: "Advanced automotive technology applications in the telecom industry.",
      },
    ],
  },
  {
    tabKey: t("indust_tech_s2_h"),
    heading: t("indust_tech_s2_h"),
    content: t("indust_tech_s2_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s2_2.png",
        heading: t("indust_consultant_s2_t1"),
        alt: "FMG technology solutions for industrial sectors.",
      },
      {
        imageUrl: "/images/fmg_s2_1.png",
        heading: t("indust_tech_s2_t2"),
        alt: "Advanced technology solutions in telecom infrastructure.",
      },
      {
        imageUrl: "/images/fmg_s2_2.png",
        heading: t("indust_tech_s2_t3"),
        alt: "Telecom industry technology integration in infrastructure.",
      },
      {
        imageUrl: "/images/automotive_s4_2.png",
        heading: t("indust_tech_s2_t4"),
        alt: "Automotive technology advancements for telecom services.",
      },
      {
        imageUrl: "/images/automotive_s2_3.png",
        heading: t("indust_tech_s2_t5"),
        alt: "Telecommunications technology enhancing automotive industries.",
      },
      {
        imageUrl: "/images/tech_s2_1.png",
        heading: t("indust_tech_s2_t6"),
        alt: "Cutting-edge technology solutions for the telecom sector.",
      },
    ],
  },
  {
    tabKey: t("indust_tech_s3_h"),
    heading: t("indust_tech_s3_h"),
    content: t("indust_tech_s3_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_tech_s3_h"),
        alt: "Telecom technology used to boost communication networks.",
      },
      {
        imageUrl: "/images/realestate_s2_2.png",
        heading: t("indust_tech_s3_t2"),
        alt: "Real estate market analysis using telecom technology.",
      },
      {
        imageUrl: "/images/fmg_s3_4.png",
        heading: t("indust_tech_s3_t3"),
        alt: "Technology-driven solutions in the telecom industry.",
      },
      {
        imageUrl: "/images/fmg_s3_3.png",
        heading: t("indust_tech_s3_t4"),
        alt: "Telecom applications in the manufacturing sector.",
      },
      {
        imageUrl: "/images/fmg_s3_2.png",
        heading: t("indust_tech_s3_t5"),
        alt: "Telecom integration for better manufacturing operations.",
      },
      {
        imageUrl: "/images/automotive_s3_4.png",
        heading: t("indust_tech_s3_t6"),
        alt: "Telecommunications technology transforming automotive industry.",
      },
      {
        imageUrl: "/images/fmg_s3_5.png",
        heading: t("indust_tech_s3_t7"),
        alt: "Next-gen technology solutions for telecom and industry sectors.",
      },
    ],
  },
  {
    tabKey: t("indust_tech_s4_h"),
    heading: t("indust_tech_s4_h"),
    content: t("indust_tech_s4_b"),
    helpHeading: t("indust_help"),
    helpImages: [
      {
        imageUrl: "/images/tech_s4_1.png",
        heading: t("indust_tech_s4_t2"),
        alt: "Innovative telecom solutions for modern technology challenges.",
      },
      {
        imageUrl: "/images/automotive_s3_2.png",
        heading: t("indust_tech_s4_t3"),
        alt: "Automotive telecom technology solutions for connected vehicles.",
      },
      {
        imageUrl: "/images/automotive_s3_1.png",
        heading: t("indust_tech_s4_t4"),
        alt: "Telecommunications technologies powering the automotive sector.",
      },
      {
        imageUrl: "/images/automotive_s3_3.png",
        heading: t("indust_tech_s4_t5"),
        alt: "Automotive technology innovations impacting the telecom industry.",
      },
    ],
  },
];

// // META TITLE AND DESCRIPTION

// export const META_TITLE_HOME = 'Market Research & Business Consulting in Saudi Arabia - Focal Point'
// export const META_DESCRIPTION_HOME = 'Discover top-notch market research, business consulting, and brand positioning services in Saudi Arabia. Specializing in qualitative and quantitative research to help your business thrive.'

// export const META_TITLE_ABOUT = 'About Us | Leading Market Research & Consulting Firm in Saudi Arabia'
// export const META_DESCRIPTION_ABOUT = 'Learn about Focal Point, a trusted partner for market research and business consulting in Saudi Arabia. Delivering data-driven insights and actionable strategies.'

// export const META_TITLE_CONTACT_US = "Contact Us | Focal Point | Market Research & Consulting in Saudi Arabia"
// export const META_DESCRIPTION_ABOUT_CONTACT_US = 'Get in touch with [Your Company Name], the leading market research and business consulting firm in Saudi Arabia. We’re here to support your growth with expert insights.'

// export const META_TITLE_AUTOMOTIVE = 'Automotive Market Research | Saudi Arabia'
// export const META_DESCRIPTION_AUTOMOTIVE = 'Drive success with expert automotive market research and analysis in Saudi Arabia. Insights into consumer behavior, product trends, and market dynamics.'

// export const META_TITLE_GOVERNMENT_AND_PUBLIC_SECTOR = 'Government Market Research | Public Sector Consulting in Saudi Arabia'
// export const META_DESCRIPTION_GOVERNMENT_AND_PUBLIC_SECTOR = 'Expert market research and consulting for the public sector in Saudi Arabia. Offering insights for policy development and effective governance.'

// export const META_TITLE_FMCG = 'FMCG Market Research | Saudi Arabia'
// export const META_DESCRIPTION_FMCG = 'Boost your FMCG strategy with tailored market research services in Saudi Arabia. Gain insights into consumer preferences and market trends.'

// export const META_TITLE_REAL_STATE = 'Real Estate Market Research | Saudi Arabia'
// export const META_DESCRIPTION_REAL_STATE = 'Delivering tailored real estate market insights in Saudi Arabia. Expert analysis to support property investments, development, and market trends.'

// export const META_TITLE_FOOD_AND_BEVRAGES = 'Food & Beverage Market Research | Saudi Arabia'
// export const META_DESCRIPTION_FOOD_AND_BEVRAGES = 'Explore food and beverage market trends in Saudi Arabia with our expert research services. From product testing to consumer insights, we’ve got you covered.'

// export const META_TITLE_CONSULTANT_AND_AGENCIES = 'Market Research for Consultants & Agencies | Saudi Arabia'
// export const META_DESCRIPTION_CONSULTANT_AND_AGENCIES = 'Providing market research services for consultants and agencies in Saudi Arabia. Insights for brand positioning, strategy development, and growth.'

// export const META_TITLE_INDUSTRIAL_MANUFACTURING = 'Industrial Manufacturing Market Research | Saudi Arabia'
// export const META_DESCRIPTION_INDUSTRIAL_MANUFACTURING = 'Expert market research for industrial manufacturing in Saudi Arabia. Gain insights into consumer behavior, market trends, and pricing strategies.'

// export const META_TITLE_TECHNOLOGY_AND_TELECOM = 'Technology & Telecom Research | Saudi Arabia'
// export const META_DESCRIPTION_TECHNOLOGY_AND_TELECOM = 'Stay ahead in tech and telecom with cutting-edge market research in Saudi Arabia. Insights into innovation, consumer behavior, and market trends.'

// export const META_TITLE_INSGIGHT = "Discover Insights, Services, and Industries with Us"
// export const META_DESCRIPTION_INSGIGHT = 'Explore actionable insights, diverse services, and tailored industry solutions. Stay informed with our latest blogs and connect with us for innovative solutions.'

// export const META_TITLE_OTHER = 'Customized Market Research & Consulting Services | Saudi Arabia'
// export const META_DESCRIPTION_OTHER = 'Explore tailored market research and consulting solutions in Saudi Arabia. Specialized services for unique industries and business challenges to drive success.'
