'use client'
import { useTheme } from 'next-themes'
import React, { useEffect, useState } from 'react'

const ChangeableImage = ({ lightPath, darkPath, alt }) => {
    const { theme } = useTheme()
    const [mounted, setMounted] = useState(false)

    useEffect(() => {
        setMounted(true)
    }, [])

    // Default to light theme during SSR to prevent hydration mismatch
    const imageSrc = mounted 
        ? ((theme === "light" || !theme) ? lightPath : darkPath)
        : lightPath

    return (
        <img 
            src={imageSrc} 
            alt={alt}
            suppressHydrationWarning
        />
    )
}

export default ChangeableImage