import CustomButton from "@/components/common/CustomButton";
import IndustriesCard from "@/components/industries/IndustriesCard";
import InsightCard from "@/components/insights/InsightCard";
import ServicesBox from "@/components/services/ServicesBox";
import { useLocale, useTranslations } from "next-intl";
import React from "react";
import FooterLink from "@/components/common/FooterLink";
import Partner from "@/components/partner/Partner";
import ChangeableImage from "@/components/common/ChangeableImage";
import Link from "next/link";
import { ROUTES, ROUTES_IDS, DOMAIN } from "@/routes";
import IconBar from "@/components/common/IconBar";
import MoveToTop from "@/components/common/MoveToTop";
import Head from "next/head";
import MapWrapper from "@/components/wrapper/MapWrapper";
import Banner from "@/components/common/Banner";
import { META_AR } from "@/seo/seo-ar";
import { META_EN } from "@/seo/seo-en";

function page() {
  const t = useTranslations("Common");
  const locale = useLocale();
  const META = locale === "ar" ? META_AR : META_EN;

  return (
    <>
      <Head>
        <title>{META.HOME.title}</title>
        <meta name="description" content={META.HOME.description} />
        <meta name="robots" content="index, follow" />
        {/* Canonical URL */}
        <link rel="canonical" href={`${DOMAIN}${ROUTES.HOME}`} />
        {/* Open Graph Meta Tags */}
        <meta property="og:title" content={META.HOME.title} />
        <meta property="og:description" content={META.HOME.description} />
        <meta property="og:type" content="website" />
        <meta property="og:url" content={`${DOMAIN}${ROUTES.HOME}`} />
        {/* Twitter Meta Tags */}
        <meta name="twitter:title" content={META.HOME.title} />
        <meta name="twitter:description" content={META.HOME.description} />
        {/* Keywords */}
        <meta name="keywords" content={META.HOME.keywords} />
      </Head>

      <div className="relative max-w-section m-auto pt-10 pb-20">
        {/* Icon Bar */}
        <IconBar />

        {/* Carousel */}
        <div id={ROUTES_IDS.HOME} className="grid grid-cols-12 gap-4">
          <div className="col-span-12">
            <Banner />
          </div>
        </div>

        {/* Generate Actionable Insights */}
        <div className="grid grid-cols-12 gap-4 my-24 lg:my-36">
          <div className="col-span-12 lg:col-span-8 !order-2 lg:!order-1">
            <h2 className="main-heading hidden lg:block">
              {t("landingpage_h_1")} <br />
              <span className="text-green">{t("landingpage_h_2")}</span> <br />
              {t("landingpage_h_3")}
            </h2>

            <h2 className="main-heading text-center block lg:hidden">
              {t("landingpage_h_1")}
              <span className="text-green"> {t("landingpage_h_2")}</span> <br />
              {t("landingpage_h_3")}
            </h2>

            <p
              className={`caption ${
                locale == "en" || !locale ? "border-left" : "border-right"
              } mt-8`}
            >
              {t("landingpage_b")}
            </p>
          </div>

          <div className="col-span-12 lg:col-span-4 order-1 lg:order-2 mx-auto">
            <ChangeableImage
              lightPath={"./images/globe-light.png"}
              darkPath={"./images/globe-dark.png"}
              alt={
                "Professional market research services tailored for Saudi businesses."
              }
            />
          </div>
        </div>

        {/* About */}
        <div
          id={ROUTES_IDS.ABOUT_US}
          className="grid grid-cols-12 gap-4 my-24 lg:my-36"
        >
          <div className="col-span-12 lg:col-span-8 !order-2 lg:!order-1">
            <h2
              className={`main-heading text-center ${
                locale == "en" || !locale ? "lg:!text-left" : "lg:!text-right"
              } `}
            >
              {t("aboutus_h")}
            </h2>
            <p
              className={`caption ${
                locale == "en" || !locale ? "border-left" : "border-right"
              } mt-8`}
            >
              {t("aboutus_b")}
            </p>

            <CustomButton
              redirectLink={ROUTES.ABOUT_US}
              className="mt-8"
              type="filled"
              text="learn_more"
            />
          </div>

          <div className="col-span-12 lg:col-span-4 order-1 lg:order-2 mx-auto">
            <ChangeableImage
              lightPath={"./images/about-light.png"}
              darkPath={"./images/about-dark.png"}
              alt={
                "Expert business strategy consulting for sustainable growth in Jeddah."
              }
            />
          </div>
        </div>

        {/* Services */}
        <div
          id={ROUTES_IDS.SERVICES}
          className="grid grid-cols-12 gap-4 my-24 lg:my-36"
        >
          <div className="col-span-12 mb-8 lg:mb-12">
            <div className="text-center">
              <h2 className="main-heading ">{t("our_services_h")}</h2>
              <p className="sub-text text-center mt-8">{t("our_services_b")}</p>
            </div>
          </div>

          <ServicesBox />
        </div>

        {/* Industries */}
        <div
          id={ROUTES_IDS.INDUSTRIES}
          className="grid grid-cols-12 gap-4 my-24 lg:my-36"
        >
          <div className="col-span-12 mb-8 lg:mb-12">
            <div className="text-center">
              <h2 className="main-heading ">{t("industries_h")}</h2>
            </div>
          </div>

          <IndustriesCard />
        </div>

        {/* Insights */}
        <div
          id={ROUTES_IDS.INSIGHTS}
          className="grid grid-cols-12 gap-4 my-24 lg:my-36"
        >
          <div className="col-span-12 mb-8 lg:mb-12">
            <div className="text-center">
              <h2 className="main-heading ">{t("blogs_h")}</h2>
              <p className="sub-text  mt-8">{t("blogs_b")}</p>
            </div>
          </div>

          <InsightCard limit={4} />

          <div className="col-span-12 mx-auto">
            <Link href={ROUTES.INSIGHTS}>
              <CustomButton type="filled" text="see_more" />
            </Link>
          </div>
        </div>

        {/* Contact */}
        <div
          id={ROUTES_IDS.CONTACT_US}
          className="grid grid-cols-12 gap-4 my-24 lg:my-36"
        >
          <div className="col-span-12 mb-8 lg:mb-12">
            <div className="text-center">
              <h2 className="main-heading ">{t("contact_h")}</h2>
              <p className="sub-text text-center mt-8">{t("contact_b")}</p>
            </div>
          </div>

          {/* Map */}
          <div className="col-span-12">
            <MapWrapper />
          </div>

          <FooterLink />
        </div>

        {/* Partner */}
        <div className="grid grid-cols-12 gap-4 mt-24 lg:mt-36">
          <Partner />
        </div>

        {/* Move to top */}
        <MoveToTop />
      </div>
    </>
  );
}

export default page;
